/*
 * json_utils.cpp
 *
 *  Created on: Aug 21, 2014
 *      Author: kl81hc
 */

#include "fc_usb_tcu_trace_classes.h"
#include "fc_usb_tcu_AppMain_Trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_USB_TCU_SERVER_FC_USB_TCU
#include "trcGenProj/Header/json_utils.cpp.trc.h"
#endif
#include "json_utils.h"
#include <string>
#include <algorithm>


/*Carwings Date JSON object names*/
tCString json_utils::U16_YEAR = "u16Year";
tCString json_utils::U8_MONTH = "u8Month";
tCString json_utils::U8_DAY = "u8Day";
tCString json_utils::U8_HOUR = "u8Hour";
tCString json_utils::U8_MINUTES = "u8Minutes";
tCString json_utils::U8_SECOND = "u8Second";

/*Carwings File Header JSON object names*/
tCString json_utils::EXPIRY_DATE = "ExpiryDate";
tCString json_utils::FILE_HEADER = "FileHeader";

/*Constant JSON object name*/
tCString json_utils::FID = "FID";
tCString json_utils::METHOD_NAME = "MethodName";
tCString json_utils::CHANNEL_MASTER_DATA = "ChannelMasterData";
tCString json_utils::CHANNEL_CMD_HEADER = "ChannelMasterDataHeader";
tCString json_utils::U8_NUM_OF_FOLDER_DEF_INFO = "u8NumOfFolderDefInfo";
tCString json_utils::U16_NUM_OF_CHANNEL_DEF_INFO = "u16NumOfChannelDefInfo";
tCString json_utils::FOLDER_DEFINITION_INFORMATION = "FolderDefinitionInformation";
tCString json_utils::U16_FOLDER_ID = "u16FolderID";
tCString json_utils::U8_MENU_CTRL_FLAG = "u8MenuCtrlFlag";
tCString json_utils::U8_CHANNEL_GEN_MODE_ID = "u8ChannelGenModeID";
tCString json_utils::DISTRIBUTION_STARTDATE = "DistributionStartDate";
tCString json_utils::DISTRIBUTION_ENDDATE = "DistributionEndDate";
tCString json_utils::U8_CHANNEL_FLAG = "u8ChannelFlag";
tCString json_utils::U8_BTN_DISPLAY_CTRL_FLAG = "u8BtnDisplayCtrlFlag";
tCString json_utils::STR_FOLDER_NAME = "strFolderName";
tCString json_utils::STR_FOLDER_NAME_FOR_TTS = "strFolderNameForTTS";
tCString json_utils::U16_FOLDER_ICON_ID = "u16FolderIconID";
tCString json_utils::CHANNEL_DEFINITION_INFORMATION = "ChannelDefinitionInformation";
tCString json_utils::U16_CHANNEL_ID = "u16ChannelID";
tCString json_utils::U8_CHANNEL_CONTENT_ID = "u8ChannelContentID";
tCString json_utils::STR_CHANNEL_NAME = "strChannelName";
tCString json_utils::STR_CHANNEL_NAME_FOR_TTS = "strChannelNameForTTS";
tCString json_utils::U8_CHANNEL_ACTION_SWID = "u8ChannelActionSWID";
tCString json_utils::U32_CHANNEL_ACTION_SW_PARAM = "u32ChannelActionSWParam";
tCString json_utils::STR_CHANNEL_ACTION_SW_NAME = "strChannelActionSWName";
tCString json_utils::U8_MOVING_RESTRICTION_FLAG_CTRL = "u8MovingRestrictionFlagCtrl";
tCString json_utils::U8_NUMBER_OF_DATA_CONTENTS_PER_ONCE = "u8NumberOfDataContentsPerOnce";
tCString json_utils::U8_TOTAL_NUM_OF_DATA_CONTENTS = "u8TotalNumOfDataContents";
tCString json_utils::U16_CHANNEL_ICON_ID = "u16ChannelIconID";
tCString json_utils::U8_FLAG_OF_CHANNEL_INFO = "u8FlagOfChannelInfo";
tCString json_utils::CHANNEL_INFO_LIST = "ChannelInfoList";
tCString json_utils::CHANNEL_DATA = "ChannelData";
tCString json_utils::CHANNEL_DATA_INFO_HEADER_PART = "ChannelDataInformationHeaderPart";
tCString json_utils::U8_CHANNEL_INFO_TYPE = "u8ChannelInfoType";
tCString json_utils::U8_NUM_OF_CHANNEL_CONTENTS = "u8NumOfChannelContents";
tCString json_utils::AUTO_PLAY_U8_NUM_OF_CHANNEL_CONTENTS = "u8Num_Of_Channel_Contents";
tCString json_utils::U8_NUM_OF_EXEC_INFO = "u8NumOfExecInfo";
tCString json_utils::U8_NUM_OF_CHANNEL_CONTENTS_AT_ONE_TIME = "u8NumOfChannelContentsAtOneTime";
tCString json_utils::U8_TOTAL_NUM_OF_CHANNEL_CONTENTS = "u8TotalNumOfChannelContents";
tCString json_utils::CHANNEL_DATA_INFORMATION_RECORD_PART = "ChannelDataInformationRecordPart";
tCString json_utils::U8_CHANNEL_CONTENT_TYPE = "u8ChannelContentType";
tCString json_utils::U8_CHANNEL_CONTENTS_ID = "u8ChannelContentsID";
tCString json_utils::STR_TITLE = "strTitle";
tCString json_utils::STR_TITLE_FOR_TTS = "strTitleForTTS";
tCString json_utils::LOCATION = "Location";
tCString json_utils::U8_DIRECTION = "u8Direction";
tCString json_utils::U8_LONGITUDE_DEGREE = "u8Longitude_Degree";
tCString json_utils::U8_LONGITUDE_MINUTE = "u8Longitude_minute";
tCString json_utils::U16_LONGITUDE_SECOND = "u16Longitude_second";
tCString json_utils::U8_LATITUDE_DEGREE = "u8Latitude_degree";
tCString json_utils::U8_LATITUDE_MINUTE = "u8Latitude_minute";
tCString json_utils::U16_LATITUDE_SECOND = "u16Latitude_second";
tCString json_utils::U8_LOCATION_ATTRIBUTE = "u8LocationAttribute";
tCString json_utils::U8_DEST_OR_WAYPOINT_TYPE = "u8DestOrWayPointType";
tCString json_utils::STR_ADDRESS = "strAddress";
tCString json_utils::STR_PHONE_NUMBER = "strPhoneNumber";
tCString json_utils::STR_PHONE_NUMBER_FOR_DISP = "strPhoneNumberForDisp";
tCString json_utils::STR_MAIL_ADDRESS = "strMailAddress";
tCString json_utils::STR_NICKNAME = "strNickname";
tCString json_utils::STR_TEXT = "strText";
tCString json_utils::STR_TEXT_FOR_TTS = "strTextForTTS";
tCString json_utils::U16_ICON_ID = "u16IconID";
tCString json_utils::U16_SOUNDID_FOR_BEGINNING_OF_PLAY = "u16SoundIDForBeginningOfPlay";
tCString json_utils::U16_SE_INFO = "u16SEInfo";
tCString json_utils::U16_SOUNDID_FOR_BGM = "u16SoundIDForBGM";
tCString json_utils::U8_ACTION_SWID = "u8ActionSWID";
tCString json_utils::U32_PARAMETEROF_ACTION_SW = "u32ParameterOfActionSW";
tCString json_utils::U8_FLAG_OF_DISP_BUTTON_CTRL = "u8FlagOfDispButtonCtrl";
tCString json_utils::U8_FLAG_OF_CTRL_DURING_RUNNING = "u8FlagOfCtrlDuringRunning";
tCString json_utils::STR_NAME_OF_IMAGE_BUTTON = "strNameOfImageButton";
tCString json_utils::STR_NAME_OF_ACTION_SW = "strNameOfActionSW";
tCString json_utils::U8_FLAG_OF_EXEC_OF_CHANNEL_CONTENTS = "u8FlagOfExecOfChannelContents";
tCString json_utils::U8_FLAG_OF_STORING_CTRL = "u8FlagOfStoringCtrl";
tCString json_utils::U8_IMAGE_AVAILABILITY = "u8ImageAvailability";
tCString json_utils::STR_IMAGE_LOCATION = "strImageLocation";
tCString json_utils::EXECUTION_INFORMATION = "ExecutionInformation";
tCString json_utils::U8_EXEC_TYPE = "u8ExecType";
tCString json_utils::EXECTION_DETAILS = "ExectionDetails";
tCString json_utils::ROUTE_CALC = "RouteCalc";
tCString json_utils::EXEC_TYPE_CALL = "Call";
tCString json_utils::EXEC_TYPE_AUTODJ_EXEC = "AutoDJExec";
tCString json_utils::EXEC_TYPE_OPERATOR_CALL = "OperatorCall";
tCString json_utils::EXEC_TYPE_AUTOPLAY_WITH_MAPPOINT = "AutoPlayWithMapPoint";

// Todo: KHOALT: Need to sync ExecType for US and PRC
tCString json_utils::SECTION_TYPE = "SectionType";
tCString json_utils::CONDITION_OF_ROUTECALC_ALL_SECTION_OR_SECTION_1 = "Condition_Of_RouteCalc_all_section_or_section_1";
tCString json_utils::CONDITION_OF_ROUTE_CALC_SECTION_2 = "Condition_Of_Route_Calc_section_2";
tCString json_utils::CONDITION_OF_ROUTE_CALC_SECTION_3 = "Condition_Of_Route_Calc_section_3";
tCString json_utils::CONDITION_OF_ROUTE_CALC_SECTION_4 = "Condition_Of_Route_Calc_section_4";
tCString json_utils::CONDITION_OF_ROUTE_CALC_SECTION_5 = "Condition_Of_Route_Calc_section_5";
tCString json_utils::CONDITION_OF_ROUTE_CALC_SECTION_6 = "Condition_Of_Route_Calc_section_6";
tCString json_utils::U16_VICS_RTIC_SETTING = "u16VICSOrRTICSetting";
tCString json_utils::DISPLIST = "DispList";
tCString json_utils::CW_SETTING = "CWSetting";
tCString json_utils::NUM_OF_CHANNEL_CONTENTS = "NumOfChannelContents";
tCString json_utils::U8_NUM_OF_TARGET_AUTODJ_CHANNELNO = "u8NumOfTargetAutoDJChannelNo";
tCString json_utils::U16_LIST_OF_TARGET_AUTODJ_CHANNELNO = "u16ListOfTargetAutoDJChannelNo";
tCString json_utils::U8_LOCATION_TO_DISPLAY = "u8LocationToDisplay";
tCString json_utils::U8_MAP_DISPLAY_SCALE = "u8MapDisplayScale";
tCString json_utils::U8_LIST_OF_CHANNEL_CONTENTS = "u8ListOfChannelContents";
tCString json_utils::CHANNEL_CONTENTS_ID = "ChannelContentsID";
tCString json_utils::AUTO_PLAY = "AutoPlay";
tCString json_utils::FAVORITE_CHANNEL_LIST = "FavoriteChannelList";
tCString json_utils::U8_NUM_OF_FAVORITE_CHANNEL_LIST = "u8NumOfFavoriteChannelList";
tCString json_utils::FAVORITE_CHANNEL_LIST_RECORD = "FavoriteChannelListRecord";
tCString json_utils::U8_FAVORITE_CHANNEL_LIST_ID = "u8FavoriteChannelListID";
tCString json_utils::U8_SETTING_MODE = "u8SettingMode";
tCString json_utils::U16_CITY_BROWSER_START_SERVICEID = "u16CityBrowserStartServiceID";

tCString json_utils::CONNECTED_SEARCH = "ConnectedSearch";
tCString json_utils::CONNECTED_SEARCH_U8_NUM_OF_POI = "u8NumOfPOI";
tCString json_utils::CONNECTED_SEARCH_DATA_RECORD = "DataRecord";
tCString json_utils::CONNECTED_SEARCH_STR_POI_NAME = "strPOIName";
tCString json_utils::CONNECTED_SEARCH_STR_ADDRESS = "strAddress";
tCString json_utils::CONNECTED_SEARCH_STR_PHONE_NUMBER = "strPhoneNumber";
tCString json_utils::CONNECTED_SEARCH_STR_PHONE_NUMBER_FOR_DISP = "strPhoneNumberForDisp";
tCString json_utils::CONNECTED_SEARCH_STR_CATEGORY = "strCategory";

tCString json_utils::DATA_CONNECTION_ERROR = "eDataConnectionError";
tCString json_utils::ERROR_REQUEST_TYPE = "u16ErrorRequestType";

tCString json_utils::DTC_CONNECTION_STATUS = "bDTCConnectionStatus";

tCString json_utils::DATA_CONNECTION_STATUS = "eDataConnectionStatus";

tCString json_utils::SERVER_LIST = "ServerList";
tCString json_utils::RESPONSE_LIST = "ResponseList";
tCString json_utils::SERVER_LIST_U8_SERVER_ID = "u8ServerId";
tCString json_utils::SERVER_LIST_STR_SERVER_NAME = "strServerName";
tCString json_utils::SERVER_LIST_STR_SERVER_ADDRESS = "strServerAddress";
tCString json_utils::SERVER_LIST_U8_CURRENT_SERVER = "u8CurrentServer";

tCString json_utils::GENERAL_NOTIFICATION_MESSAGE = "GeneralNotificationMessage";
tCString json_utils::U8_NOTI_RESULT = "u8Result";
tCString json_utils::STR_DISPLAY_MESSAGE = "strDisplayMessage";
tCString json_utils::STR_TTS_TEXT_MESSAGE = "strTTSTextMessage";

tCString json_utils::ICON_LIST = "IconList";
tCString json_utils::ICON_ID = "u16IconID";
tCString json_utils::ICON_DATA_TYPE = "u8IconDataType";
tCString json_utils::ICON_FOR_MAP_DAY_TIME = "strIconForMapDaytime";
tCString json_utils::ICON_FOR_MENU_DAY_TIME = "strIconForMenuDaytime";
tCString json_utils::ICON_FOR_MAP_NIGHT = "strIconForMapNight";
tCString json_utils::ICON_FOR_MENU_NIGHT = "strIconForMenuNight";

tCString json_utils::GENERAL_RESPONSE = "GeneralResponse";
tCString json_utils::REQUEST_ID = "u16RequestID";
tCString json_utils::RESPONSE_ID ="u8ResponseID";
// GJD5KOR : Added Types for PROBE_CONFIGURATION
tCString json_utils::PROBE_CONFIGURATION = "ProbeConfiguration";
tCString json_utils::ANALYSISCODE = "u8AnalysisCode";
tCString json_utils::CONFIGURATIONVERSION = "u16ConfigurationVersion";
tCString json_utils::FUNCTIONCODE = "u8FunctionCode";
tCString json_utils::REMOTESENDINGSIZE = "RemoteSendingSize";
tCString json_utils::TRACKING = "u8Tracking";
tCString json_utils::CALCULATED = "u8Calculated";
tCString json_utils::MATSUSHITACOMPRESSION = "u16MatsushitaCompression";
tCString json_utils::ACQUISITIONDEFINITION = "AcquisitionDefinition";
tCString json_utils::NAVIINFORMATION = "NaviInformation";
tCString json_utils::LABEL = "u8Label";
tCString json_utils::REMOTESENDINGFLAG = "u8RemoteSendingFlag";
tCString json_utils::STORETRIGGER = "u8StoreTrigger";
tCString json_utils::STOREINTERVAL = "u8StoreInterval";
tCString json_utils::DATATHINNING = "u8DataThinning";
tCString json_utils::DATAINTERVAL = "u8DataInterval";
tCString json_utils::CALCULATEDINFORMATION = "CalculatedInformation";
tCString json_utils::THRESHOLD = "u8Threshold";
tCString json_utils::THRESHOLD1 = "Threshold1";
tCString json_utils::TYPE = "u8Type";
tCString json_utils::DATA = "u8Data";
tCString json_utils::THRESHOLD2 = "Threshold2";
tCString json_utils::THRESHOLD3 = "Threshold3";
tCString json_utils::YEAR = "u8Year";
tCString json_utils::MONTH ="u8Month";
tCString json_utils::DAY = "u8Day";
tCString json_utils::TIME = "u8Time";
tCString json_utils:: MINUTE = "u8Minute";
tCString json_utils::SECOND ="u8Second";
tCString json_utils::TIMESOZNE ="s8Timezone";
tCString json_utils::LATITUDE = "s32Latitude";
tCString json_utils::LONGITUDE ="s32Longitude";
tCString json_utils::TRIPFUELINJECTIONQUANTITY = "u32TripFuelInjectionQuantity";
tCString json_utils::IMMIDIATEACCELARATIONTIMEINTRIP = "u16ImmediateAccelerationTimeInTrip";
tCString json_utils::MILEAGECOVEREDINTRIP = "u32MileageCoveredInTrip";
tCString json_utils::WARMUPTIMEINTRIP = "u16WarmUpTimeInTrip";
tCString json_utils::MONTHLYFUELINJECTIONQUANTITY = "u32MonthlyFuelInjectionQuantity";
tCString json_utils::MONTHLYMILEAGECOVERED = "u16MonthlyMileageCovered";
tCString json_utils::MONTHLYFREQUENCYOF4000ROTATIONUSING = "u16MonthlyFrequencyOf4000RotationUsing";
tCString json_utils::MONTHLYFREQUENCYOF6000ROTATIONUSING = "u16MonthlyFrequencyOf6000RotationUsing";
tCString json_utils::DRIVINGTIMEDURINGENTIRELIFETIME = "u32DrivingTimeDuringEntireLifeTime";
tCString json_utils::FUELINJECTIONQUANTITYDURINGENTIRELIFETIME = "u32FuelInjectionQuantityDuringEntireLifeTime";
tCString json_utils::MILEAGEDURINGENTIRELIFETIME = "u32MileageDuringEntireLifeTime";
tCString json_utils::GEOFLAG = "u8GeoFlag";
tCString json_utils::INFORMATIONTYPE = "u8InformationType";
tCString json_utils::LABELSINFO = "LabelsInfo";
tCString json_utils::PROBEINFORMATION = "ProbeVehicleInformation";
tCString json_utils::AUTHENTICATIONRESULTDATA = "AuthenticationResultData";
tCString json_utils::U8_AUTHENTICATION_RESULT = "u8Result";
tCString json_utils::STR_AUTH_DISPLAY_MESSAGE = "strDisplayMessage";
tCString json_utils::STR_AUTH_TTS_MESSAGE = "strTTSTextMessage";

tCString json_utils::MAPVERSION ="sMapVersion";
tCString json_utils::IVIID = "sIVIID";
tCString json_utils::ITMPROBEVERSION = "sITMProbeVersion";
tCString json_utils::COMMONINFO = "CommonInfo";

/* SMB6KOR : Added Types for EV variant */
tCString json_utils::U32_REQ_ID = "ReqID";
tCString json_utils::U32_POIID = "u32POIID";
tCString json_utils::U8_SIZE_OF_POI_NAME = "u8SizeOfPOIName";
tCString json_utils::STR_POI_NAME = "strPOIName";
tCString json_utils::STR_AREA_CODE1 = "strAreaCode1";
tCString json_utils::STR_AREA_CODE2 = "strAreaCode2";
tCString json_utils::STR_AREA_CODE3 = "strAreaCode3";
tCString json_utils::STR_AREA_CODE4 = "strAreaCode4";
tCString json_utils::STR_AREA_CODE5 = "strAreaCode5";
tCString json_utils::STR_AREA_CODE6 = "strAreaCode6";
tCString json_utils::STR_AREA_CODE7 = "strAreaCode7";
tCString json_utils::STR_AREA_CODE8 = "strAreaCode8";
tCString json_utils::U8_SIZE_OF_STREET_AND_HOUSE_NO = "u8SizeOfStreetAndHouseNo";
tCString json_utils::STR_STREET_AND_HOUSE_NO = "strStreetAndHouseNo";
tCString json_utils::U16_CATEGORY_CODE = "u16Categorycode";
tCString json_utils::U16_SUB_CATEGORY_CODE = "u16Subcategorycode";
tCString json_utils::U8_SIZE_OF_TELEPHONE_NUMBER = "u8SizeOfTelephonenumber";
tCString json_utils::STR_TELEPHONE_NUMBER = "strTelephonenumber";
tCString json_utils::U8_EXPRESS_WAY_GENERAL_TYPE = "u8Expresswaygeneraltype";
tCString json_utils::U8_INFORMATION_RELIABILITY = "u8Informationreliability";
tCString json_utils::U8_USER_RESTRICTION = "u8Userrestriction";
tCString json_utils::U32_USER_RESTRICTION_ID = "u32UserrestrictionID";
tCString json_utils::U8_THE_NUMBER_OF_ENTRANCE_INFORMATION = "u8Thenumberofentranceinformation";
tCString json_utils::U8_ENTRANCE_INFORMATION = "u8Entranceinformation";
tCString json_utils::U8_THE_NUMBER_OF_PARTNERS_FACILITY_INFORMATION = "u8Thenumberofpartnersfacilityinformation";
tCString json_utils::U8_PARTNERS_FACILITY_INFORMATION = "u8Partnersfacilityinformation";
tCString json_utils::U8_THE_NUMBER_OF_INSTALLATION_FACILITY_INFORMATION = "u8Thenumberofinstallationfacilityinformation";
tCString json_utils::U8_INSTALLATION_FACILITY_INFORMATION = "u8Installationfacilityinformation";
tCString json_utils::U8_THE_TOTAL_NUMBER_OF_CHARGING_TYPE = "u8Thetotalnumberofchargingtype";
tCString json_utils::U8_CHARGING_TYPE = "u8Chargingtype";
tCString json_utils::U16_PARKING_NUMBER = "u16Parkingnumber";
tCString json_utils::U8_FIXED_VALUE_1 = "u8Fixedvalue1";
tCString json_utils::U8_FIXED_VALUE_2 = "u8Fixedvalue2";
tCString json_utils::U16_SIZE_OF_DETAIL_INFORMATION = "u16Sizeofdetailinformation";
tCString json_utils::U8_DETAILS_INFORMATION = "u8Detailsinformation";
tCString json_utils::U8_24_HOURS_A_DAY_INFORMATION = "u8_24hoursadayinformation";
tCString json_utils::U8_OFFICE_HOURS_UNKNOWN_INFORMATION = "u8Officehoursunknowninformation";
tCString json_utils::U8_CHARGING_FEE_INFORMATION = "u8Chargingfeeinformation";
tCString json_utils::U8_BUSINESS_DAY_OF_THE_WEEK_INFORMATION = "u8Businessdayoftheweekinformation";
tCString json_utils::U16_OPENING_HOUR_INFORMATION = "u16OpeninghourInformation";
tCString json_utils::U16_CLOSED_HOUR_INFORMATION = "u16ClosedhourInformation";
tCString json_utils::U8_NEAR_THE_FACILITY_INFORMATION = "u8Nearthefacilityinformation";
tCString json_utils::U16_PAYMENT_TYPE_INFORMATION = "u16Paymenttypeinformation";

//@rav1hc: chargingSpotData for JPN
tCString json_utils::STR_POI_NAME_FOR_TTS= "strPOINameForTTS";
tCString json_utils::STR_AREA_NAME1 = "strAreaName1";
tCString json_utils::STR_AREA_NAME2 = "strAreaName2";
tCString json_utils::STR_OOAZA_AND_ADD = "strOoazaAndAddress";
tCString json_utils::U8_USER_LIMIT = "u8UserLimit";
tCString json_utils::U32_USER_LIMIT_ID = "u32UserLimitID";
tCString json_utils::ENTRANCE_INFORMATION_LIST = "EntranceinformationList";
tCString json_utils::PARTNERS_FACILITY_INFORMATION_LIST = "PartnersfacilityinformationList";
tCString json_utils::INSTALLATION_FACILITY_INFORMATION_LIST = "InstallationfacilityinformationList";
tCString json_utils::CHARGING_TYPE_LIST = "ChargingtypeList";
tCString json_utils::CHARGING_TYPE = "ChargingType";
tCString json_utils::CHARGING_INFOMATION_LIST = "ChargingInfomationList";
tCString json_utils::STR_DETAILS_INFORMATION = "strDetailsinformation";
tCString json_utils::POI_POSITION_INFORMATION = "POIPositionInformation";
tCString json_utils::STR_IDENTIFICATION_NAME = "strIdentificationName";

//@rav1hc: Vacancy Spot Data
tCString  json_utils::VACANCY_SPOT_DATA = "VacancySpotData";
tCString  json_utils::U8_VACANCY_STATUS= "u8VacancyStatus";//u8VacancyStatus
tCString  json_utils::U8_NUMBER_OF_AVAILABLE_CONNECTOR= "u8TheNumberOfAvailableConnector";//u8TheNumberOfAvailableConnector
tCString  json_utils::U8_NUMBER_OF_BUSY_CONNECTOR= "u8TheNumberOfBusyConnector";
tCString  json_utils::U8_NUMBER_OF_UNKNOWN_CONNECTOR= "u8TheNumberOfUknownConnector";
tCString  json_utils::INFOMATION_PROVISION_TIME= "InformationProvisionTime";
tCString  json_utils::STR_INFOMATION_PROVIDER= "strInformationProvision";
tCString  json_utils::STR_NETWORK_NAME= "strNetworkName";
tCString  json_utils::U8_RESERVATION_AVAILABILITY_FLAG= "u8ReservationAvailabilityFlag";

tCString json_utils::PARTNERS_FACILITY = "PartnersFacility";
tCString json_utils::STR_PARTNERS_FACILITY_NAME = "strPartnersFacilityName";

tCString json_utils::INSTALLATION_FACILITY_INFORMATION = "InstallationFacility";
tCString json_utils::STR_INSTALLATION_FACILITY_NAME = "strInstallationFacilityName";

tCString json_utils::U8_CHARGING_METHOD = "u8ChargingMethod";
tCString json_utils::U8_SET_CONNECTOR_TYPE = "u8Setconnectortype";
tCString json_utils::U8_THE_NUMBER_OF_CONNECTOR = "u8Thenumberofsetconnector";

tCString json_utils::LIST_OF_CHARGING_STATIONS_HEADER = "SearchResultListOfChargingStationsHeader";
tCString json_utils::U8_POI_DATA_SET_INDENTIFICATION_ID_TYPE = "u8POIDataSetIdentificationIDType";
tCString json_utils::U32_POI_DATA_SET_INDENTIFICATION_ID = "u32POIDataSetIdentificationID";
tCString json_utils::U32_NUMBER_OF_POI_ID = "u32NumberOfPOIID";
tCString json_utils::U32_POI_ID_VERSION = "u32POIIDVersion";
tCString json_utils::CHARGING_STATIONS = "SearchResultListOfChargingStations";
tCString json_utils::VACANCY_STATIONS = "SearchResultListOfVacancyStations";
tCString json_utils::CHARGING_SPOT_DATA = "ChargingSpotData";
tCString json_utils::POIID_LIST_DATA = "POIIDList";
tCString json_utils::U8_POI_DATASET_IDENTIFICATION_ID_TYPE = "u8POIDataSetIdentificationIDType";
tCString json_utils::U32_POI_DATASET_IDENTIFICATION_ID = "u32POIDataSetIdentificationID";

tCString json_utils::PART_AUTH_RESPONSE = "Response";
tCString json_utils::PART_AUTH_REQUEST_TYPE = "reqType";
tCString json_utils::PART_AUTH_STATUS_CODE = "statusCode";
tCString json_utils::PART_AUTH_BODY = "body";
tCString json_utils::PART_AUTH_SN = "sn";
tCString json_utils::PART_AUTH_CERTIFICATE = "certificate";
tCString json_utils::PART_AUTH_REGION = "region";
tCString json_utils::PART_AUTH_PARTITION = "partition";
tCString json_utils::PART_AUTH_ERROR_MESSAGE = "errorMessage";
tCString json_utils::PART_AUTH_ERROR_ID = "errorID";

tCString json_utils::USER_AUTH_RESPONSE = "Response";
tCString json_utils::USER_AUTH_REQUEST_TYPE = "reqType";
tCString json_utils::USER_AUTH_STATUS_CODE = "statusCode";
tCString json_utils::USER_AUTH_BODY = "body";
tCString json_utils::USER_AUTH_ACCESS_TOKEN = "access_token";
tCString json_utils::USER_AUTH_REFRESH_TOKEN = "refresh_token";
tCString json_utils::USER_AUTH_SCOPE = "scope";
tCString json_utils::USER_AUTH_ID_TOKEN = "id_token";
tCString json_utils::USER_AUTH_TOKEN_TYPE = "token_type";
tCString json_utils::USER_AUTH_EXPIRES_IN = "expires_in";
tCString json_utils::USER_AUTH_DED_ID = "DedId";
tCString json_utils::USER_AUTH_ERROR_DESCRIPTION = "error_description";
tCString json_utils::USER_AUTH_ERROR = "error";
tCString json_utils::USER_AUTH_TOKEN = "Tokens";
tCString json_utils::DECODED_TOKEN_KID = "KID";

tCString json_utils::VICS_FILE_PATH = "VICSData";


json_utils::json_utils()
{
	ETG_TRACE_USR1(("json_utils()"));
}
json_utils::~json_utils()
{
	ETG_TRACE_USR1(("~json_utils()"));
}
tBool json_utils::getJSONObject(Json::Value& input, tCString jsonObjName, Json::Value& output) {
	Json::Value value = input.get(jsonObjName, Json::Value::null);

	if (!value.isObject()) {
		ETG_TRACE_USR2(("%s is not an Object",jsonObjName));
		return FALSE;
	} else if(value == Json::Value::null){ // Cannot find JSONObject for wrong name.
		ETG_TRACE_USR2(("%s cannot be found",jsonObjName));
		return FALSE;
	} else {
		output = value;
		return TRUE;
	}
}

tBool json_utils::getJSONArray(Json::Value& input, tCString jsonObjName, Json::Value& output) {

	Json::Value value = input.get(jsonObjName, Json::Value::null);

	if(value == Json::Value::null){ // Cannot find JSONArray for wrong name.
		ETG_TRACE_USR2(("%s cannot be found",jsonObjName));
		return FALSE;
	} else if (!value.isArray()) {
		ETG_TRACE_USR2(("%s is not an Array",jsonObjName));
		return FALSE;
	}
//	else if (value.isArray() && value.size() == 0) {
//		ETG_TRACE_USR2(("%s is empty",jsonObjName));
//		return FALSE;
//	}
	else if (value.isArray()) {
		output = value;
		return TRUE;
	}

	return FALSE;
}

tBool json_utils::getString(Json::Value& input, tCString jsonObjName, bpstl::string& output) {

	Json::Value value = input.get(jsonObjName, Json::Value::null);

	if(value == Json::Value::null){ // Cannot find JSONArray for wrong name.
		ETG_TRACE_USR2(("%s cannot be found",jsonObjName));
		return FALSE;
	} else if (!value.isString()) {
		ETG_TRACE_USR2(("%s is not an String",jsonObjName));
		return FALSE;
	} else {
		bpstl::string temp = value.asCString();
		output = temp;
		return TRUE;
	}
}

tBool json_utils::gettBool(Json::Value& input, tCString jsonObjName, tBool& output) {
	Json::Value value = input.get(jsonObjName, Json::Value::null);

	if(value == Json::Value::null){ // Cannot find JSONArray for wrong name.
		ETG_TRACE_USR2(("%s cannot be found",jsonObjName));
		return FALSE;
	} else if (!value.isBool()) {
		ETG_TRACE_USR2(("%s is not a Bool",jsonObjName));
		return FALSE;
	} else {
		output = value.asBool();
		return TRUE;
	}
}

tBool json_utils::gettU8UInt(Json::Value& input, tCString jsonObjName, tU8& output) {
	Json::Value value = input.get(jsonObjName, Json::Value::null);

	if(value == Json::Value::null){ // Cannot find JSONArray for wrong name.
		ETG_TRACE_USR2(("%s cannot be found",jsonObjName));
		return FALSE;
	} else if (!value.isInt()) {
		ETG_TRACE_USR2(("%s is not an Integer",jsonObjName));
		return FALSE;
	} else {
		output = (tU8) value.asUInt();
		return TRUE;
	}
}

tBool json_utils::gettU16UInt(Json::Value& input, tCString jsonObjName, tU16& output) {
	Json::Value value = input.get(jsonObjName, Json::Value::null);

	if(value == Json::Value::null){ // Cannot find JSONArray for wrong name.
		ETG_TRACE_USR2(("%s cannot be found",jsonObjName));
		return FALSE;
	} else if (!value.isInt()) {
		ETG_TRACE_USR2(("%s is not an Integer",jsonObjName));
		return FALSE;
	} else {
		output = (tU16) value.asUInt();
		return TRUE;
	}
}

tBool json_utils::gettU32UInt(Json::Value& input, tCString jsonObjName, tU32& output) {
	Json::Value value = input.get(jsonObjName, Json::Value::null);

	if(value == Json::Value::null){ // Cannot find JSONArray for wrong name.
		ETG_TRACE_USR2(("%s cannot be found",jsonObjName));
		return FALSE;
	} else if (!value.isInt()) { //old isInt
		ETG_TRACE_USR2(("%s is not an Integer",jsonObjName));
		if(value.isUInt()){
			ETG_TRACE_USR2(("%s is an big Integer",jsonObjName));
			output = (tU32) value.asUInt();
			return TRUE;
		}
		return FALSE;
	} else {
		output = (tU32) value.asUInt();
		return TRUE;
	}
}

tBool json_utils::gettU64UInt(Json::Value& input, tCString jsonObjName, tU64& output) {
	Json::Value value = input.get(jsonObjName, Json::Value::null);

	if(value == Json::Value::null){ // Cannot find JSONArray for wrong name.
		ETG_TRACE_USR2(("%s cannot be found",jsonObjName));
		return FALSE;
	} else if (!value.isInt()) {
		ETG_TRACE_USR2(("%s is not an Integer",jsonObjName));
		if(value.isUInt()){
			ETG_TRACE_USR2(("%s is an big Integer",jsonObjName));
			output = (tU32) value.asUInt();
			return TRUE;
		}
		return FALSE;
	} else {
		output = (tU64) value.asUInt();
		return TRUE;
	}
}

bpstl::string json_utils::processingTTSText(bpstl::string originalText) {
    ETG_TRACE_USR2(("->processingTTSText: %s",originalText.c_str()));
    bpstl::string resultStr = originalText;
    //  FC_USB_TCU_NULL_POINTER_CHECK_VAL(_poKDSHandler);
    //  if(tcu_usb_fi_tcl_e8_tcu_Regions::FI_EN_REGION_JPN == _poKDSHandler->u8GetRegion()){
    //      //replace your codes here
    //  }else{
    //      //replace your codes here
    //  }

    //remove header  #!ntts:speed=0,key=0,bass=0,volume=0:
    size_t pos = 0;
    pos = originalText.find("#!ntts:");
    if(pos!=std::string::npos){
        //find ":" end of header
        pos = originalText.find(':', pos + 7 ); // 7 mean length of #"!ntts:" , ignore frist ":"
            if(pos!=std::string::npos){
                resultStr.assign(originalText.begin() + pos + 1, originalText.end()); // find latest ":" in header
        }
    }

    //remove accent
    resultStr.erase(std::remove(resultStr.begin(), resultStr.end(), '%'), resultStr.end());
    resultStr.erase(std::remove(resultStr.begin(), resultStr.end(), '\''), resultStr.end());
    resultStr.erase(std::remove(resultStr.begin(), resultStr.end(), '*'), resultStr.end());
    resultStr.erase(std::remove(resultStr.begin(), resultStr.end(), '"'), resultStr.end());
    resultStr.erase(std::remove(resultStr.begin(), resultStr.end(), '/'), resultStr.end());

    /*  control "pause" as per Nuance engine specification
     *   a.  Replace ‘:’ -> <ESC>\pause=100\
     *   b.  Replace ‘.’ -> <ESC>\pause=800\ IVI should change the tone lower and make 800ms pause
     *   c.  Replace ‘,’ -> <ESC>\pause=100\
     *   d.  Replace ‘?’ -> <ESC>\pause=800\ IVI should change the tone upper and make 800ms pause
     *   e.  <ESC> mean 0x1B ( = 27);     *
     */

    //replace "."
    bpstl::string toSearch = ".";
    bpstl::string toReplace = "\x1B\\pause=800\\"; /*<ESC>\pause=800\*/
    while ((pos = resultStr.find(toSearch)) != std::string::npos) {
        resultStr.replace(pos, toSearch.length(), toReplace);
    };

    //replace ":"
    toSearch = ":";
    toReplace = "\x1B\\pause=100\\"; /*<ESC>\pause=100\*/
    while ((pos = resultStr.find(toSearch)) != std::string::npos) {
        resultStr.replace(pos, toSearch.length(), toReplace);
    };

    //replace ","
    toSearch = ",";
    toReplace = "\x1B\\pause=100\\"; /*<ESC>\pause=100\*/
    while ((pos = resultStr.find(toSearch)) != std::string::npos) {
        resultStr.replace(pos, toSearch.length(), toReplace);
    };

    //replace "?"
    toSearch = "?";
    toReplace = "\x1B\\pause=800\\"; /*<ESC>\pause=100\*/
    while ((pos = resultStr.find(toSearch)) != std::string::npos) {
        resultStr.replace(pos, toSearch.length(), toReplace);
    };

    //trim string
    const bpstl::string& chars = "\t\n\v\f\r " ; // white space
    //left trim
    resultStr.erase(0, resultStr.find_first_not_of(chars));
    //right trim
    resultStr.erase(resultStr.find_last_not_of(chars) + 1);


    return resultStr;
}
